/*
 * Globalize Culture th
 *
 * http://github.com/jquery/globalize
 *
 * Copyright Software Freedom Conservancy, Inc.
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * This file was generated by the Globalize Culture Generator
 * Translation: bugs found in this file need to be fixed in the generator
 */

(function( window, undefined ) {

var Globalize;

if ( typeof require !== "undefined" &&
	typeof exports !== "undefined" &&
	typeof module !== "undefined" ) {
	// Assume CommonJS
	Globalize = require( "globalize" );
} else {
	// Global variable
	Globalize = window.Globalize;
}

Globalize.addCultureInfo( "th", "default", {
	name: "th",
	englishName: "Thai",
	nativeName: "ไทย",
	language: "th",
	numberFormat: {
		currency: {
			pattern: ["-$n","$n"],
			symbol: "฿"
		}
	},
	calendars: {
		standard: {
			name: "ThaiBuddhist",
			firstDay: 1,
			days: {
				names: ["อาทิตย์","จันทร์","อังคาร","พุธ","พฤหัสบดี","ศุกร์","เสาร์"],
				namesAbbr: ["อา.","จ.","อ.","พ.","พฤ.","ศ.","ส."],
				namesShort: ["อ","จ","อ","พ","พ","ศ","ส"]
			},
			months: {
				names: ["มกราคม","กุมภาพันธ์","มีนาคม","เมษายน","พฤษภาคม","มิถุนายน","กรกฎาคม","สิงหาคม","กันยายน","ตุลาคม","พฤศจิกายน","ธันวาคม",""],
				namesAbbr: ["ม.ค.","ก.พ.","มี.ค.","เม.ย.","พ.ค.","มิ.ย.","ก.ค.","ส.ค.","ก.ย.","ต.ค.","พ.ย.","ธ.ค.",""]
			},
			eras: [{"name":"พ.ศ.","start":null,"offset":-543}],
			twoDigitYearMax: 2572,
			patterns: {
				d: "d/M/yyyy",
				D: "d MMMM yyyy",
				t: "H:mm",
				T: "H:mm:ss",
				f: "d MMMM yyyy H:mm",
				F: "d MMMM yyyy H:mm:ss",
				M: "dd MMMM",
				Y: "MMMM yyyy"
			}
		},
		Gregorian_Localized: {
			firstDay: 1,
			days: {
				names: ["อาทิตย์","จันทร์","อังคาร","พุธ","พฤหัสบดี","ศุกร์","เสาร์"],
				namesAbbr: ["อา.","จ.","อ.","พ.","พฤ.","ศ.","ส."],
				namesShort: ["อ","จ","อ","พ","พ","ศ","ส"]
			},
			months: {
				names: ["มกราคม","กุมภาพันธ์","มีนาคม","เมษายน","พฤษภาคม","มิถุนายน","กรกฎาคม","สิงหาคม","กันยายน","ตุลาคม","พฤศจิกายน","ธันวาคม",""],
				namesAbbr: ["ม.ค.","ก.พ.","มี.ค.","เม.ย.","พ.ค.","มิ.ย.","ก.ค.","ส.ค.","ก.ย.","ต.ค.","พ.ย.","ธ.ค.",""]
			},
			patterns: {
				d: "d/M/yyyy",
				D: "'วัน'dddd'ที่' d MMMM yyyy",
				t: "H:mm",
				T: "H:mm:ss",
				f: "'วัน'dddd'ที่' d MMMM yyyy H:mm",
				F: "'วัน'dddd'ที่' d MMMM yyyy H:mm:ss",
				M: "dd MMMM",
				Y: "MMMM yyyy"
			}
		}
	}
});

}( this ));
(function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}
var dict = {
  "box user": "ผู้ใช้",
  "filetype_box user": "ผู้ใช้",
  "html": "ไฟล์ HTML",
  "filetype_html": "ไฟล์ HTML",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "เว็บเพจ",
  "filetype_webscraperwebpage": "เว็บเพจ",
  "image": "รูปภาพ",
  "filetype_image": "รูปภาพ",
  "folder": "โฟลเดอร์",
  "filetype_folder": "โฟลเดอร์",
  "txt": "ข้อความ",
  "filetype_txt": "ข้อความ",
  "zip": "ไฟล์ Zip",
  "filetype_zip": "ไฟล์ Zip",
  "olefile": "ไฟล์ OLE",
  "filetype_olefile": "ไฟล์ OLE",
  "gmailmessage": "ข้อความ Gmail",
  "filetype_gmailmessage": "ข้อความ Gmail",
  "pdf": "ไฟล์ PDF",
  "filetype_pdf": "ไฟล์ PDF",
  "swf": "ไฟล์ Flash",
  "filetype_swf": "ไฟล์ Flash",
  "xml": "ไฟล์ XML",
  "filetype_xml": "ไฟล์ XML",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "เปิด Office",
  "filetype_svm": "เปิด Office",
  "rssitem": "ฟีด RSS",
  "filetype_rssitem": "ฟีด RSS",
  "doc": "เอกสาร",
  "filetype_doc": "เอกสาร",
  "docx": "เอกสาร Microsoft Word",
  "filetype_docx": "เอกสาร Microsoft Word",
  "xls": "เอกสารสเปรดชีท",
  "filetype_xls": "เอกสารสเปรดชีท",
  "ppt": "เอกสารการนำเสนอ",
  "filetype_ppt": "เอกสารการนำเสนอ",
  "video": "วิดีโอ",
  "filetype_video": "วิดีโอ",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "เปิดเอกสารข้อความ",
  "filetype_odt": "เปิดเอกสารข้อความ",
  "lithiummessage": "ข้อความ Lithium",
  "filetype_lithiummessage": "ข้อความ Lithium",
  "lithiumthread": "เธรด Lithium",
  "filetype_lithiumthread": "เธรด Lithium",
  "lithiumboard": "บอร์ด Lithium",
  "filetype_lithiumboard": "บอร์ด Lithium",
  "lithiumcategory": "หมวดหมู่ Lithium",
  "filetype_lithiumcategory": "หมวดหมู่ Lithium",
  "lithiumcommunity": "ชุมชน Lithium",
  "filetype_lithiumcommunity": "ชุมชน Lithium",
  "people": "ผู้ใช้",
  "objecttype_people": "ผู้ใช้",
  "message": "ข้อความ",
  "objecttype_message": "ข้อความ",
  "feed": "ฟีด RSS",
  "objecttype_feed": "ฟีด RSS",
  "thread": "เธรด",
  "objecttype_thread": "เธรด",
  "file": "ไฟล์",
  "objecttype_file": "ไฟล์",
  "board": "บอร์ด",
  "objecttype_board": "บอร์ด",
  "category": "หมวดหมู่",
  "objecttype_category": "หมวดหมู่",
  "account": "บัญชี",
  "objecttype_account": "บัญชี",
  "annotation": "หมายเหตุ",
  "objecttype_annotation": "หมายเหตุ",
  "campaign": "แคมเปญ",
  "objecttype_campaign": "แคมเปญ",
  "case": "กรณี",
  "objecttype_case": "กรณี",
  "contact": "ติดต่อ",
  "objecttype_contact": "ติดต่อ",
  "contract": "สัญญา",
  "objecttype_contract": "สัญญา",
  "event": "กิจกรรม",
  "objecttype_event": "กิจกรรม",
  "email": "อีเมล",
  "objecttype_email": "อีเมล",
  "goal": "เป้าหมาย",
  "objecttype_goal": "เป้าหมาย",
  "incident": "กรณี",
  "objecttype_incident": "กรณี",
  "invoice": "ใบแจ้งหนี้",
  "objecttype_invoice": "ใบแจ้งหนี้",
  "lead": "ลีด",
  "objecttype_lead": "ลีด",
  "list": "รายการ",
  "objecttype_list": "รายการด้านการตลาด",
  "solution": "โซลูชัน",
  "objecttype_solution": "โซลูชัน",
  "task": "งาน",
  "objecttype_task": "งาน",
  "user": "ผู้ใช้",
  "objecttype_user": "ผู้ใช้",
  "attachment": "เอกสารแนบ",
  "objecttype_attachment": "เอกสารแนบ",
  "casecomment": "ข้อคิดเห็นต่อกรณี",
  "objecttype_casecomment": "ข้อคิดเห็นต่อกรณี",
  "opportunity": "โอกาส",
  "objecttype_opportunity": "โอกาส",
  "opportunityproduct": "ผลิตภัณฑ์ที่มีโอกาส",
  "objecttype_opportunityproduct": "ผลิตภัณฑ์ที่มีโอกาส",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "หมายเหตุ",
  "objecttype_note": "หมายเหตุ",
  "product": "ผลิตภัณฑ์",
  "objecttype_product": "ผลิตภัณฑ์",
  "partner": "พันธมิตร",
  "objecttype_partner": "พันธมิตร",
  "queueitem": "รายการคิว",
  "objecttype_queueitem": "รายการคิว",
  "quote": "แจ้งราคา",
  "objecttype_quote": "แจ้งราคา",
  "salesliterature": "การบันทึกข้อมูลที่ได้ติดต่อลูกค้า",
  "objecttype_salesliterature": "การบันทึกข้อมูลที่ได้ติดต่อลูกค้า",
  "salesorder": "คำสั่งขาย",
  "objecttype_salesorder": "คำสั่งขาย",
  "service": "บริการ",
  "objecttype_service": "บริการ",
  "socialprofile": "โปรไฟล์สังคม",
  "objecttype_socialprofile": "โปรไฟล์สังคม",
  "kbdocumentation": "เอกสารประกอบ",
  "objecttype_kbdocumentation": "เอกสารประกอบ",
  "kbtechnicalarticle": "เอกสารประกอบ",
  "objecttype_kbtechnicalarticle": "เอกสารประกอบ",
  "kbsolution": "โซลูชัน",
  "objecttype_kbsolution": "โซลูชัน",
  "kbknowledgearticle": "บทความให้ความรู้",
  "objecttype_kbknowledgearticle": "บทความให้ความรู้",
  "kbattachment": "เอกสารแนบ",
  "objecttype_kbattachment": "เอกสารแนบ",
  "kbarticle": "บทความ",
  "objecttype_kbarticle": "บทความ",
  "kbarticlecomment": "ข้อคิดเห็นในบทความ",
  "objecttype_kbarticlecomment": "ข้อคิดเห็นในบทความ",
  "knowledgearticle": "บทความให้ความรู้",
  "objecttype_knowledgearticle": "บทความให้ความรู้",
  "topic": "หัวข้อ",
  "objecttype_topic": "หัวข้อ",
  "dashboard": "แดชบอร์ด",
  "objecttype_dashboard": "แดชบอร์ด",
  "contentversion": "เอกสาร",
  "objecttype_contentversion": "เอกสาร",
  "collaborationgroup": "กลุ่มความร่วมมือ",
  "objecttype_collaborationgroup": "กลุ่มความร่วมมือ",
  "spportal": "พอร์ทัล",
  "filetype_spportal": "พอร์ทัล",
  "spsite": "ไซต์",
  "filetype_spsite": "ไซต์",
  "spuserprofile": "ผู้ใช้ SharePoint",
  "filetype_spuserprofile": "ผู้ใช้ SharePoint",
  "sparea": "พื้นที่",
  "filetype_sparea": "พื้นที่",
  "spannouncement": "คำประกาศ",
  "filetype_spannouncement": "คำประกาศ",
  "spannouncementlist": "คำประกาศ",
  "filetype_spannouncementlist": "คำประกาศ",
  "spcontact": "ติดต่อ",
  "filetype_spcontact": "ติดต่อ",
  "spcontactlist": "ผู้ติดต่อ",
  "filetype_spcontactlist": "ผู้ติดต่อ",
  "spcustomlist": "รายการแบบกำหนดเอง",
  "filetype_spcustomlist": "รายการแบบกำหนดเอง",
  "spdiscussionboard": "กระดานสนทนา",
  "filetype_spdiscussionboard": "กระดานสนทนา",
  "spdiscussionboardlist": "กระดานสนทนา",
  "filetype_spdiscussionboardlist": "กระดานสนทนา",
  "spdocumentlibrarylist": "คลังเอกสาร",
  "filetype_spdocumentlibrarylist": "คลังเอกสาร",
  "spevent": "กิจกรรม",
  "filetype_spevent": "กิจกรรม",
  "speventlist": "กิจกรรม",
  "filetype_speventlist": "กิจกรรม",
  "spformlibrarylist": "ึคลังรูปแบบ",
  "filetype_spformlibrarylist": "ึคลังรูปแบบ",
  "spissue": "ปัญหา",
  "filetype_spissue": "ปัญหา",
  "spissuelist": "ปัญหา",
  "filetype_spissuelist": "ปัญหา",
  "splink": "ลิงก์",
  "filetype_splink": "ลิงก์",
  "splinklist": "ลิงก์",
  "filetype_splinklist": "ลิงก์",
  "sppicturelibrarylist": "คลังรูปภาพ",
  "filetype_sppicturelibrarylist": "คลังรูปภาพ",
  "spsurvey": "การสำรวจ",
  "filetype_spsurvey": "การสำรวจ",
  "spsurveylist": "การสำรวจ",
  "filetype_spsurveylist": "การสำรวจ",
  "sptask": "งาน",
  "filetype_sptask": "งาน",
  "sptasklist": "งาน",
  "filetype_sptasklist": "งาน",
  "spagenda": "ระเบียบวาระ",
  "filetype_spagenda": "ระเบียบวาระ",
  "spagendalist": "ระเบียบวาระ",
  "filetype_spagendalist": "ระเบียบวาระ",
  "spattendee": "ผู้เข้าร่วม",
  "filetype_spattendee": "ผู้เข้าร่วม",
  "spattendeelist": "ผู้เข้าร่วม",
  "filetype_spattendeelist": "ผู้เข้าร่วม",
  "spcustomgridlist": "กริดแบบกำหนดเอง",
  "filetype_spcustomgridlist": "กริดแบบกำหนดเอง",
  "spdecision": "การตัดสินใจ",
  "filetype_spdecision": "การตัดสินใจ",
  "spdecisionlist": "การตัดสินใจ",
  "filetype_spdecisionlist": "การตัดสินใจ",
  "spobjective": "วัตถุประสงค์",
  "filetype_spobjective": "วัตถุประสงค์",
  "spobjectivelist": "วัตถุประสงค์",
  "filetype_spobjectivelist": "วัตถุประสงค์",
  "sptextbox": "กล่องข้อความ",
  "filetype_sptextbox": "กล่องข้อความ",
  "sptextboxlist": "รายการกล่องข้อความ",
  "filetype_sptextboxlist": "รายการกล่องข้อความ",
  "spthingstobring": "สิ่งที่จะต้องนำเสนอ",
  "filetype_spthingstobring": "สิ่งที่จะต้องนำเสนอ",
  "spthingstobringlist": "สิ่งที่จะต้องนำเสนอ",
  "filetype_spthingstobringlist": "สิ่งที่จะต้องนำเสนอ",
  "sparealisting": "รายการพื้นที่",
  "filetype_sparealisting": "รายการพื้นที่",
  "spmeetingserie": "ลำดับการประชุม",
  "filetype_spmeetingserie": "ลำดับการประชุม",
  "spmeetingserielist": "รายการลำดับการประชุม",
  "filetype_spmeetingserielist": "รายการลำดับการประชุม",
  "spsitedirectory": "รายการไดเร็กทอรีของไซต์",
  "filetype_spsitedirectory": "รายการไดเร็กทอรีของไซต์",
  "spsitedirectorylist": "ไดเร็กทอรีของไซต์",
  "filetype_spsitedirectorylist": "ไดเร็กทอรีของไซต์",
  "spdatasource": "แหล่งข้อมูล",
  "filetype_spdatasource": "แหล่งข้อมูล",
  "spdatasourcelist": "รายการแหล่งข้อมูล",
  "filetype_spdatasourcelist": "รายการแหล่งข้อมูล",
  "splisttemplatecataloglist": "แกลเลอรีเท็มเพลตของรายการ",
  "filetype_splisttemplatecataloglist": "แกลเลอรีเท็มเพลตของรายการ",
  "spwebpartcataloglist": "แกลเลอรี WebPart",
  "filetype_spwebpartcataloglist": "แกลเลอรี WebPart",
  "spwebtemplatecataloglist": "แกลเลอรีเท็มเพลตของไซต์",
  "filetype_spwebtemplatecataloglist": "แกลเลอรีเท็มเพลตของไซต์",
  "spworkspacepagelist": "หน้า Workspace",
  "filetype_spworkspacepagelist": "หน้า Workspace",
  "spunknownlist": "รายการแบบกำหนดเอง",
  "filetype_spunknownlist": "รายการแบบกำหนดเอง",
  "spadministratortask": "งานของผู้ดูแล",
  "filetype_spadministratortask": "งานของผู้ดูแล",
  "spadministratortasklist": "งานของผู้ดูแล",
  "filetype_spadministratortasklist": "งานของผู้ดูแล",
  "spareadocumentlibrarylist": "คลังเอกสารเกี่ยวกับพื้นที่",
  "filetype_spareadocumentlibrarylist": "คลังเอกสารเกี่ยวกับพื้นที่",
  "spblogcategory": "หมวดหมู่บล็อก",
  "filetype_spblogcategory": "หมวดหมู่บล็อก",
  "spblogcategorylist": "หมวดหมู่บล็อก",
  "filetype_spblogcategorylist": "หมวดหมู่บล็อก",
  "spblogcomment": "ข้อคิดเห็นในบล็อก",
  "filetype_spblogcomment": "ข้อคิดเห็นในบล็อก",
  "spblogcommentlist": "ข้อคิดเห็นในบล็อก",
  "filetype_spblogcommentlist": "ข้อคิดเห็นในบล็อก",
  "spblogpost": "โพสต์ในบล็อก",
  "filetype_spblogpost": "โพสต์ในบล็อก",
  "spblogpostlist": "โพสต์ในบล็อก",
  "filetype_spblogpostlist": "โพสต์ในบล็อก",
  "spdataconnectionlibrarylist": "คลังการเชื่อมโยงข้อมูล",
  "filetype_spdataconnectionlibrarylist": "คลังการเชื่อมโยงข้อมูล",
  "spdistributiongroup": "กลุ่มการกระจาย",
  "filetype_spdistributiongroup": "กลุ่มการกระจาย",
  "spdistributiongrouplist": "กลุ่มการกระจาย",
  "filetype_spdistributiongrouplist": "กลุ่มการกระจาย",
  "spipfslist": "InfoPath Forms Servers",
  "filetype_spipfslist": "InfoPath Forms Servers",
  "spkeyperformanceindicator": "ตัวชี้วัดผลการปฏิบัติงานหลัก",
  "filetype_spkeyperformanceindicator": "ตัวชี้วัดผลการปฏิบัติงานหลัก",
  "spkeyperformanceindicatorlist": "ตัวชี้วัดผลการปฏิบัติงานหลัก",
  "filetype_spkeyperformanceindicatorlist": "ตัวชี้วัดผลการปฏิบัติงานหลัก",
  "splanguagesandtranslator": "ภาษาและผู้แปล",
  "filetype_splanguagesandtranslator": "ภาษาและผู้แปล",
  "splanguagesandtranslatorlist": "ภาษาและผู้แปล",
  "filetype_splanguagesandtranslatorlist": "ภาษาและผู้แปล",
  "spmasterpagescataloglist": "แกลเลอรีเพจหลัก",
  "filetype_spmasterpagescataloglist": "แกลเลอรีเพจหลัก",
  "spnocodeworkflowlibrarylist": "คลังขั้นตอนการทำงานแบบไม่มีรหัส",
  "filetype_spnocodeworkflowlibrarylist": "คลังขั้นตอนการทำงานแบบไม่มีรหัส",
  "spprojecttask": "งานในโครงการ",
  "filetype_spprojecttask": "งานในโครงการ",
  "spprojecttasklist": "งานในโครงการ",
  "filetype_spprojecttasklist": "งานในโครงการ",
  "sppublishingpageslibrarylist": "คลังของเพจ",
  "filetype_sppublishingpageslibrarylist": "คลังของเพจ",
  "spreportdocumentlibrarylist": "คลังเอกสารรายงาน",
  "filetype_spreportdocumentlibrarylist": "คลังเอกสารรายงาน",
  "spreportlibrarylist": "คลังรายงาน",
  "filetype_spreportlibrarylist": "คลังรายงาน",
  "spslidelibrarylist": "คลังสไลด์",
  "filetype_spslidelibrarylist": "คลังสไลด์",
  "sptab": "ปุ่มแท็บ",
  "filetype_sptab": "ปุ่มแท็บ",
  "sptablist": "รายการแท็บ",
  "filetype_sptablist": "รายการแท็บ",
  "sptranslationmanagementlibrarylist": "คลังการจัดการการแปล",
  "filetype_sptranslationmanagementlibrarylist": "คลังการจัดการการแปล",
  "spuserinformation": "ข้อมูลผู้ใช้",
  "filetype_spuserinformation": "ข้อมูลผู้ใช้",
  "spuserinformationlist": "รายการข้อมูลผู้ใช้",
  "filetype_spuserinformationlist": "รายการข้อมูลผู้ใช้",
  "spwikipagelibrarylist": "คลังเพจ Wiki",
  "filetype_spwikipagelibrarylist": "คลังเพจ Wiki",
  "spworkflowhistory": "ประวัติขั้นตอนการทำงาน",
  "filetype_spworkflowhistory": "ประวัติขั้นตอนการทำงาน",
  "spworkflowhistorylist": "รายการประวัติขั้นตอนการทำงาน",
  "filetype_spworkflowhistorylist": "รายการประวัติขั้นตอนการทำงาน",
  "spworkflowprocess": "ขั้นตอนการทำงานแบบกำหนดเอง",
  "filetype_spworkflowprocess": "ขั้นตอนการทำงานแบบกำหนดเอง",
  "spworkflowprocesslist": "ขั้นตอนการทำงานแบบกำหนดเอง",
  "filetype_spworkflowprocesslist": "ขั้นตอนการทำงานแบบกำหนดเอง",
  "sppublishingimageslibrarylist": "คลังรูปภาพสำหรับการเผยแพร่",
  "filetype_sppublishingimageslibrarylist": "คลังรูปภาพสำหรับการเผยแพร่",
  "spcirculation": "การเผยแพร่",
  "filetype_spcirculation": "การเผยแพร่",
  "spcirculationlist": "การเผยแพร่",
  "filetype_spcirculationlist": "การเผยแพร่",
  "spdashboardslibrarylist": "คลังแดชบอร์ด",
  "filetype_spdashboardslibrarylist": "คลังแดชบอร์ด",
  "spdataconnectionforperformancepointlibrarylist": "คลังการเชื่อมโยงข้อมูล PerformancePoint",
  "filetype_spdataconnectionforperformancepointlibrarylist": "คลังการเชื่อมโยงข้อมูล PerformancePoint",
  "sphealthreport": "รายงานสุขภาพ",
  "filetype_sphealthreport": "รายงานสุขภาพ",
  "sphealthreportlist": "รายงานสุขภาพ",
  "filetype_sphealthreportlist": "รายงานสุขภาพ",
  "sphealthrule": "กฎเกี่ยวกับสุขภาพ",
  "filetype_sphealthrule": "กฎเกี่ยวกับสุขภาพ",
  "sphealthrulelist": "กฎเกี่ยวกับสุขภาพ",
  "filetype_sphealthrulelist": "กฎเกี่ยวกับสุขภาพ",
  "spimedictionary": "พจนานุกรม IME",
  "filetype_spimedictionary": "พจนานุกรม IME",
  "spimedictionarylist": "พจนานุกรม IME",
  "filetype_spimedictionarylist": "พจนานุกรม IME",
  "spperformancepointcontent": "เนื้อหา PerformancePoint",
  "filetype_spperformancepointcontent": "เนื้อหา PerformancePoint",
  "spperformancepointcontentlist": "เนื้อหา PerformancePoint",
  "filetype_spperformancepointcontentlist": "เนื้อหา PerformancePoint",
  "spphonecallmemo": "บันทึกการโทร",
  "filetype_spphonecallmemo": "บันทึกการโทร",
  "spphonecallmemolist": "บันทึกการโทร",
  "filetype_spphonecallmemolist": "บันทึกการโทร",
  "sprecordlibrarylist": "คลังบันทึก",
  "filetype_sprecordlibrarylist": "คลังบันทึก",
  "spresource": "ทรัพยากร",
  "filetype_spresource": "ทรัพยากร",
  "spresourcelist": "ทรัพยากร",
  "filetype_spresourcelist": "ทรัพยากร",
  "spprocessdiagramslibrarylist": "คลังแผนภาพขั้นตอน",
  "filetype_spprocessdiagramslibrarylist": "คลังแผนภาพขั้นตอน",
  "spsitethemeslibrarylist": "ึคลังธีมของไซต์",
  "filetype_spsitethemeslibrarylist": "ึคลังธีมของไซต์",
  "spsolutionslibrarylist": "คลังโซลูชัน",
  "filetype_spsolutionslibrarylist": "คลังโซลูชัน",
  "spwfpublibrarylist": "คลัง WFPUB",
  "filetype_spwfpublibrarylist": "คลัง WFPUB",
  "spwhereabout": "ตำแหน่งที่ตั้ง",
  "filetype_spwhereabout": "ตำแหน่งที่ตั้ง",
  "spwhereaboutlist": "ตำแหน่งที่ตั้ง",
  "filetype_spwhereaboutlist": "ตำแหน่งที่ตั้ง",
  "spdocumentlink": "เชื่อมโยงไปยังเอกสาร",
  "filetype_spdocumentlink": "เชื่อมโยงไปยังเอกสาร",
  "spdocumentset": "ชุดเอกสาร",
  "filetype_spdocumentset": "ชุดเอกสาร",
  "spmicrofeedpost": "โพสต์ใน Microfeed",
  "filetype_spmicrofeedpost": "โพสต์ใน Microfeed",
  "spmicrofeedlist": "Microfeed",
  "filetype_spmicrofeedlist": "Microfeed",
  "splistfolder": "โฟลเดอร์รายการ",
  "filetype_splistfolder": "โฟลเดอร์รายการ",
  "Unknown": "ที่ไม่รู้จัก",
  "And": "และ",
  "Authenticating": "กำลังพิสูจน์ความถูกต้องของ {0}...",
  "Clear": "ล้าง {0}",
  "CompleteQuery": "คิวรีทั้งหมด",
  "Exclude": "ไม่รวม {0}",
  "EnterTag": "เพิ่มแท็ก",
  "Next": "ถัดไป",
  "Last": "ท้ายสุด",
  "Link": "ลิงก์",
  "Or": "หรือ",
  "Previous": "ก่อนหน้า",
  "QueryDidntMatchAnyDocuments": "คิวรีของคุณไม่ตรงกับเอกสารใดๆ",
  "QueryException": "คิวรีของคุณมีข้อผิดพลาด: {0}",
  "Me": "ฉัน",
  "Remove": "นำออก",
  "Search": "ค้นหา",
  "SearchFor": "ค้นหา {0}",
  "ShareQuery": "แบ่งปันคิวรี",
  "Preferences": "ลักษณะที่ต้องการ",
  "LinkOpeningSettings": "การตั้งค่าการเปิดลิงก์",
  "Reauthenticate": "พิสูจน์ความถูกต้องของ {0} ใหม่อีกครั้ง",
  "ResultsFilteringExpression": "นิพจน์การกรองผลลัพธ์",
  "FiltersInYourPreferences": "ตัวกรองในลักษณะที่ต้องการของคุณ",
  "Create": "สร้าง",
  "SearchIn": "ค้นหาใน {0}",
  "Seconds": "ใน {0} วินาที",
  "ShowingResultsOf": "ผลลัพธ์ที่ {0}<pl>-{1}</pl> จาก {2}",
  "ShowingResultsOfWithQuery": "ผลลัพธ์ที่ {0}<pl>-{1}</pl> จาก {2}",
  "SwitchTo": "เปลี่ยนเป็น {0}",
  "Unexclude": "ไม่แยก {0}",
  "ClearAllFilters": "ล้างตัวกรองทั้งหมด",
  "SkipLogin": "ข้ามการลงชื่อเข้าใช้",
  "LoginInProgress": "กำลังลงชื่อเข้าใช้ โปรดรอ...",
  "Login": "ลงชื่อเข้าใช้",
  "GetStarted": "เริ่มต้น",
  "More": "เพิ่มเติม",
  "NMore": "{0} เพิ่มเติม...",
  "Less": "น้อยลง",
  "Settings": "การตั้งค่า",
  "Score": "คะแนน",
  "ScoreDescription": "คำนวณคะแนนจากจำนวนครั้งของเหตุการณ์ที่เกิดรวมถึงตำแหน่งในชุดผลลัพธ์",
  "Occurrences": "เหตุการณ์ที่เกิด",
  "OccurrencesDescription": "จัดเรียงตามจำนวนครั้งของเหตุการณ์ที่เกิดจากมากสุดไปหาน้อยสุด",
  "Label": "ป้าย",
  "Of": "ของ",
  "LabelDescription": "จัดเรียงตามลำดับอักษรในค่าฟิลด์",
  "Value": "ค่า",
  "ValueDescription": "จัดเรียงตามค่าของฟิลด์ที่คำนวณก่อน",
  "AlphaAscending": "ค่าน้อยไปมาก",
  "AlphaDescending": "ค่ามากไปน้อย",
  "ChiSquare": "ไคสแควร์",
  "Nosort": "ไม่มีการจัดเรียง",
  "NosortDescription": "ห้ามจัดเรียงค่า ค่าจะถูกส่งกลับในลำดับแบบสุ่ม",
  "RelativeFrequency": "ความถี่สัมพัทธ์",
  "RelativeFrequencyDescription": "จัดเรียงตามความถี่สัมพัทธ์ของค่า โดยค่าที่มีความถี่น้อยที่สุดจะปรากฎอยู่บนสุด",
  "DateDistribution": "การแจกแจงวัน",
  "Custom": "กำหนดเอง",
  "CustomDescription": "จัดเรียงตามลำดับที่กำหนดเอง",
  "ComputedField": "ฟิลด์ที่คำนวณ",
  "Ascending": "มากไปหาน้อย",
  "Descending": "น้อยไปหามาก",
  "noResultFor": "ไม่พบผลลัพธ์สำหรับ {0}",
  "autoCorrectedQueryTo": "คิวรีได้รับการแก้ไขโดยอัตโนมัติเป็น {0}",
  "didYouMean": "คุณหมายถึง: {0} หรือไม่",
  "SuggestedResults": "ผลลัพธ์ที่แนะนำ",
  "SuggestedQueries": "คิวรีที่แนะนำ",
  "MostRelevantItems": "รายการที่เกี่ยวข้องที่สุด:",
  "AllItems": "รายการทั้งหมด:",
  "ShowLess": "แสดงน้อยลง",
  "ShowMore": "แสดงเพิ่มขึ้น",
  "HideFacet": "ซ่อนแฟเซ็ท",
  "ShowFacet": "แสดงแฟเซ็ท",
  "AndOthers": "และ{0}อื่น<pl>ๆ</pl>",
  "Others": "{0}อื่น<pl>ๆ</pl>",
  "MostRelevantPosts": "โพสต์ที่เกี่ยวข้องที่สุด:",
  "CompleteThread": "กระทู้แบบสมบูรณ์:",
  "ShowCompleteThread": "แสดงกระทู้แบบสมบูรณ์",
  "ShowOnlyTopMatchingPosts": "แสดงเฉพาะกระทู้ที่ตรงที่สุดเท่านั้น",
  "MostRelevantReplies": "การตอบกลับที่เกี่ยวข้องที่สุด:",
  "AllConversation": "บทสนทนาทั้งหมด:",
  "ShowAllConversation": "แสดงบทสนทนาทั้งหมด",
  "ShowAllReplies": "แสดงการตอบกลับทั้งหมด",
  "ShowOnlyMostRelevantReplies": "แสดงเฉพาะการตอบกลับที่เกี่ยวข้องที่สุดเท่านั้น",
  "Close": "ปิด",
  "Open": "เปิด",
  "OpenInOutlookWhenPossible": "เปิดใน Outlook (เมื่อสามารถทำได้)",
  "AlwaysOpenInNewWindow": "เปิดผลลัพธ์ในหน้าต่างใหม่เสมอ",
  "Quickview": "มุมมองด่วน",
  "NoQuickview": "มุมมองด่วนสำหรับเอกสารนี้ไม่พร้อมใช้งาน",
  "ErrorReport": "การรายงานข้อผิดพลาด",
  "OopsError": "เกิดข้อผิดพลาดบางอย่างกับเซิร์ฟเวอร์",
  "ProblemPersists": "หากปัญหายังคงอยู่ โปรดติดต่อผู้ดูแล",
  "GoBack": "ย้อนกลับ",
  "Reset": "รีเซ็ต",
  "Retry": "ลองใหม่",
  "MoreInfo": "ข้อมูลเพิ่มเติม",
  "Username": "ชื่อผู้ใช้",
  "Password": "รหัสผ่าน",
  "PostedBy": "โพสต์โดย",
  "CannotConnect": "ไม่สามารถเชื่อมต่อที่อยู่เซิร์ฟเวอร์ได้",
  "BadUserPass": "รหัสผ่านไม่ตรงกับชื่อผู้ใช้",
  "PleaseEnterYourCredentials": "โปรดกรอกหลักฐานอ้างอิงของคุณสำหรับ {0}",
  "PleaseEnterYourSearchPage": "โปรดกรอก URL หน้าการค้นหาของคุณ",
  "Collapse": "ยุบ",
  "Collapsable": "ยุบได้",
  "Expand": "ขยาย",
  "Today": "วันนี้",
  "Yesterday": "เมื่อวาน",
  "Tomorrow": "พรุ่งนี้",
  "Duration": "ระยะเวลา: {0}",
  "IndexDuration": "ระยะเวลาของดัชนี: {0}",
  "ProxyDuration": "ระยะเวลาของพร็อกซี่: {0}",
  "ClientDuration": "ระยะเวลาของไคลเอนต์: {0}",
  "Unavailable": "ไม่มี",
  "Reply": "ตอบกลับ",
  "ReplyAll": "ตอบกลับทั้งหมด",
  "Forward": "ส่งต่อ",
  "From": "จาก",
  "Caption": "หัวข้อ",
  "Expression": "นิพจน์",
  "Tab": "ปุ่มแท็บ",
  "Tabs": "ปุ่มแท็บ",
  "EnterExpressionName": "ป้อนชื่อนิพจน์",
  "EnterExpressionToFilterWith": "ป้อนนิพจน์เพื่อกรองผลลัพธ์",
  "SelectTab": "เลือกปุ่มแท็บ",
  "SelectAll": "เลือกทั้งหมด",
  "PageUrl": "เลือก URL หน้า",
  "ErrorSavingToDevice": "เกิดข้อผิดพลาดขณะบันทึกข้อมูลลงในอุปกรณ์ของคุณ",
  "ErrorReadingFromDevice": "เกิดข้อผิดพลาดขณะอ่านข้อมูลจากอุปกรณ์ของคุณ",
  "AppIntro": "พูดคุยกับผู้เชี่ยวชาญด้านผลิตภัณฑ์ซึ่งสามารถตอบคำถามของคุณเกี่ยวกับ Coveo และช่วยคุณตัดสินใจว่าโซลูชัน Coveo ใดที่เหมาะสมกับคุณ หรือทดลองใช้ผลิตภัณฑ์ตัวอย่าง!",
  "TryDemo": "ทดลองใช้ตัวอย่าง",
  "ContactUs": "ติดต่อเรา",
  "NewToCoveo": "เพิ่งเริ่มใช้ Coveo ใช่ไหม",
  "LetUsHelpGetStarted": "ให้เราช่วยคุณในการเริ่มต้น",
  "LikesThis": "{0} ถูกใจ สิ่งนี้",
  "CannotConnectSearchPage": "ไม่สามารถเชื่อมต่อหน้าการค้นหาของคุณได้",
  "AreYouSureDeleteFilter": "คุณแน่ใจหรือไม่ว่าคุณต้องการลบตัวกรอง {0} ที่มีนิพจน์ {1}",
  "OnlineHelp": "ความช่วยเหลือออนไลน์",
  "Done": "เสร็จเรียบร้อย",
  "SaveFacetState": "บันทึกสถานะแฟเซ็ทนี้",
  "ClearFacetState": "ล้างสถานะแฟเซ็ท",
  "DisplayingTheOnlyMessage": "แสดงเฉพาะข้อความในการสนทนานี้",
  "NoNetworkConnection": "ไม่มีการเชื่อมต่อเครือข่าย",
  "UnknownConnection": "การเชื่อมต่อที่ไม่รู้จัก",
  "EthernetConnection": "การเชื่อมต่ออีเทอร์เน็ต",
  "WiFi": "การเชื่อมต่อ WiFi",
  "CELL": "การเชื่อมต่อเซลลูลาร์",
  "CELL_2G": "การเชื่อมต่อเซลลูลาร์ 2 จี",
  "CELL_3G": "การเชื่อมต่อเซลลูลาร์ 3 จี",
  "CELL_4G": "การเชื่อมต่อเซลลูลาร์ 4 จี",
  "Relevance": "ความสัมพันธ์กัน",
  "Date": "วัน",
  "Amount": "จำนวน",
  "QueryExceptionNoException": "ไม่มีสิ่งผิดปกติ",
  "QueryExceptionInvalidSyntax": "ซินแท็กซ์ไม่ถูกต้อง",
  "QueryExceptionInvalidCustomField": "ฟิลด์กำหนดเองไม่ถูกต้อง",
  "QueryExceptionInvalidDate": "วันไม่ถูกต้อง",
  "QueryExceptionInvalidExactPhrase": "วลีแบบตรงทั้งหมดไม่ถูกต้อง",
  "QueryExceptionInvalidDateOp": "ตัวปฏิบัติการวันไม่ถูกต้อง",
  "QueryExceptionInvalidNear": "ตัวปฏิบัติการ NEAR ไม่ถูกต้อง",
  "QueryExceptionInvalidWeightedNear": "NEAR ถ่วงน้ำหนักไม่ถูกต้อง",
  "QueryExceptionInvalidTerm": "คำศัพท์ไม่ถูกต้อง",
  "QueryExceptionTooManyTerms": "มีคำศัพท์มากเกินไป",
  "QueryExceptionWildcardTooGeneral": "อักขรแทนกว้างเกินไป",
  "QueryExceptionInvalidSortField": "ฟิลด์จัดเรียงไม่ถูกต้อง",
  "QueryExceptionInvalidSmallStringOp": "ตัวปฏิบัติการสตริงเล็กไม่ถูกต้อง",
  "QueryExceptionRequestedResultsMax": "จำนวนสูงสุดของผลลัพธ์ที่ร้องขอ",
  "QueryExceptionAggregatedMirrorDead": "ดัชนีระยะไกลออฟไลน์",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "คิวรีดัชนีระยะไกลหมดเวลา",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "หมายเลขสร้างดัชนีระยะไกลไม่ถูกต้อง",
  "QueryExceptionAggregatedMirrorCannotConnect": "ดัชนีระยะไกลไม่สามารถเชื่อมต่อได้",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "อักขรแทนมีอักษรนำไม่เพียงพอ",
  "QueryExceptionSecurityInverterNotFound": "ไม่พบตัวผกผันเพื่อความปลอดภัย",
  "QueryExceptionSecurityInverterAccessDenied": "การเข้าถึงตัวผกผันเพื่อความปลอดภัยถูกปฏิเสธ",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "ดัชนีระยะไกลไม่สามารถเลียนแบบได้",
  "QueryExceptionUnexpected": "ที่ไม่คาดคิด",
  "QueryExceptionAccessDenied": "การเข้าถึงถูกปฏิเสธ",
  "QueryExceptionSuperUserTokenInvalid": "โทเคนของซูเปอร์ยูสเซอร์ไม่ถูกต้อง",
  "QueryExceptionSuperUserTokenExpired": "โทเคนของซูเปอร์ยูสเซอร์หมดอายุ",
  "QueryExceptionLicenseQueriesExpired": "ใบอนุญาตคิวรีหมดอายุแล้ว",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "ไม่สนับสนุนโทเคนของซูเปอร์ยูสเซอร์ของใบอนุญาต",
  "QueryExceptionInvalidSession": "เซสชันไม่ถูกต้อง",
  "QueryExceptionInvalidDocument": "เอกสารไม่ถูกต้อง",
  "QueryExceptionSearchDisabled": "ปิดการค้นหา",
  "FileType": "ประเภทไฟล์",
  "ShowAttachment": "แสดงเอกสารแนบ",
  "OnFeed": "บนฟีดของ {0}",
  "Author": "ผู้สร้าง",
  "NoTitle": "ไม่มีชื่อ",
  "CurrentSelections": "รายการที่เลือกในปัจจุบัน",
  "AllContent": "เนื้อหาทั้งหมด",
  "CancelLastAction": "ยกเลิกการกระทำล่าสุด",
  "SearchTips": "เคล็ดลับการค้นหา",
  "CheckSpelling": "ตรวจสอบตัวสะกดของคำสำคัญของคุณ",
  "TryUsingFewerKeywords": "ลองใช้คำสำคัญที่น้อยลง แตกต่าง หรือมีความหมายกว้างขึ้น",
  "SelectFewerFilters": "เลือกตัวกรองให้น้อยลงเพื่อขยายขอบเขตการค้นหาของคุณ",
  "Document": "เอกสาร",
  "Time": "เวลา",
  "StartDate": "วันที่เริ่มต้น",
  "StartTime": "เวลาเริ่มต้น",
  "DurationTitle": "ระยะเวลา",
  "UserQuery": "คิวรีของผู้ใช้",
  "ShowUserActions": "แสดงการดำเนินการของผู้ใช้",
  "NoData": "ไม่มีข้อมูลที่ใช้ได้",
  "EventType": "ประเภทกิจกรรม",
  "GoToFullSearch": "การค้นหาทั้งหมด",
  "GoToEdition": "กำหนดแผงเอง",
  "RemoveContext": "นำบริบทออก",
  "BoxAttachToCase": "แนบไปที่กรณี",
  "AttachToCase": "แนบไปที่กรณี",
  "Attach": "แนบ",
  "Attached": "แนบแล้ว",
  "Detach": "ถอดออก",
  "Details": "รายละเอียด",
  "AdditionalFilters": "ตัวกรองเพิ่มเติม",
  "SelectNonContextualSearch": "นำบริบทออกจากเร็กคอร์ดปัจจุบันเพื่อขยายการค้นหาของคุณ",
  "CopyPasteToSupport": "คัดลอกและวางข้อความนี้สำหรับทีมสนับสนุน Coveo สำหรับข้อมูลเพิ่มเติม",
  "FollowQueryDescription": "แจ้งฉันสำหรับการเปลี่ยนแปลงในผลการค้นหาของคิวรีนี้",
  "SearchAlerts_Panel": "จัดการการแจ้งเตือน",
  "SearchAlerts_PanelDescription": "ดูและจัดการการแจ้งเตือนการค้นหาของคุณ",
  "SearchAlerts_PanelNoSearchAlerts": "คุณไม่ได้สมัครสมาชิก",
  "SearchAlerts_Fail": "บริการแจ้งเตือนการค้นหาไม่พร้อมใช้งานในขณะนี้",
  "SearchAlerts_Type": "ประเภท",
  "SearchAlerts_Content": "เนื้อหา",
  "SearchAlerts_Actions": "การกระทำ",
  "EmptyQuery": "<empty>",
  "SearchAlerts_Type_followQuery": "คิวรี",
  "SearchAlerts_Type_followDocument": "รายการ",
  "SearchAlerts_unFollowing": "หยุดการติดตาม",
  "SearchAlerts_follow": "ติดตาม",
  "SearchAlerts_followed": "ติดตามแล้ว",
  "SearchAlerts_followQuery": "ติดตามคิวรี",
  "Subscription_StopFollowingQuery": "หยุดการติดตามคิวรี",
  "SearchAlerts_Frequency": "เวลา",
  "SubscriptionsManageSubscriptions": "จัดการการแจ้งเตือน",
  "SubscriptionsMessageFollowQuery": "คุณจะได้รับการแจ้งเตือนเมื่อคิวรี<b>{0}</b>แสดงรายการใหม่หรือที่อัปเดต",
  "SubscriptionsMessageFollow": "คุณจะได้รับการแจ้งเตือนสำหรับการเปลี่ยนแปลงในรายการ<b>{0}</b>",
  "Expiration": "การหมดอายุ",
  "Monthly": "รายเดือน",
  "Daily": "รายวัน",
  "Monday": "วันจันทร์",
  "Tuesday": "วันอังคาร",
  "Wednesday": "วันพุธ",
  "Thursday": "วันพฤหัสบดี",
  "Friday": "วันศุกร์",
  "Saturday": "วันเสาร์",
  "Sunday": "วันอาทิตย์",
  "NextDay": "ถัดไป {0}",
  "LastDay": "ท้ายสุด {0}",
  "StartTypingCaseForSuggestions": "อธิบายปัญหาของคุณเพื่อหาทางออกที่เป็นไปได้",
  "ExportToExcel": "ส่งออกไปที่ Excel",
  "ExportToExcelDescription": "ส่งออกผลการค้นหาไปที่ Excel",
  "CaseCreationNoResults": "ไม่พบโซลูชันที่แนะนำ",
  "SortBy": "จัดเรียงตาม",
  "BoxCreateArticle": "สร้างบทความ",
  "Facets": "แฟเซ็ท",
  "AdvancedSearch": "การค้นหาขั้นสูง",
  "Keywords": "คำสำคัญ",
  "AllTheseWords": "คำเหล่านี้ทั้งหมด",
  "ExactPhrase": "วลีแบบตรง",
  "AnyOfTheseWords": "คำเหล่านี้คำใดก็ได้",
  "NoneOfTheseWords": "ไม่มีคำเหล่านี้",
  "Anytime": "เวลาใดก็ได้",
  "InTheLast": "ในช่วงสุดท้าย",
  "Days": "วัน",
  "Months": "เดือน",
  "Month": "เดือน",
  "Year": "ปี",
  "Between": "ระหว่าง",
  "Language": "ภาษา",
  "Size": "ขนาด",
  "AtLeast": "อย่างน้อยที่สุด",
  "AtMost": "อย่างมากที่สุด",
  "Contains": "มี",
  "DoesNotContain": "ไม่มี",
  "Matches": "จับคู่",
  "Bytes": "ไบต์",
  "card": "บัตร",
  "table": "ตาราง",
  "ResultLinks": "การเชื่อมโยงผลลัพธ์",
  "EnableQuerySyntax": "เปิดใช้งานซินแท็กซ์คิวรี",
  "On": "เปิด",
  "Off": "ปิด",
  "Automatic": "อัตโนมัติ",
  "ResultsPerPage": "ผลลัพธ์ต่อหน้า",
  "PreviousMonth": "เดือนก่อนหน้า",
  "NextMonth": "เดือนถัดไป",
  "Title": "ชื่อ",
}
  var locales = String["locales"] || (String["locales"] = {});
  locales["th"] = merge(locales["th"], dict);
  String["toLocaleString"].call(this, { "th": dict });
  String["locale"] = "th";
  String["defaultLocale"] = "en";
  Globalize.culture("th")})();
if(!window.Coveo){window.Coveo = {};}
Coveo.setLanguageAfterPageLoaded = function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}

var dict = {
  "box user": "ผู้ใช้",
  "filetype_box user": "ผู้ใช้",
  "html": "ไฟล์ HTML",
  "filetype_html": "ไฟล์ HTML",
  "wiki": "Wiki",
  "filetype_wiki": "Wiki",
  "webscraperwebpage": "เว็บเพจ",
  "filetype_webscraperwebpage": "เว็บเพจ",
  "image": "รูปภาพ",
  "filetype_image": "รูปภาพ",
  "folder": "โฟลเดอร์",
  "filetype_folder": "โฟลเดอร์",
  "txt": "ข้อความ",
  "filetype_txt": "ข้อความ",
  "zip": "ไฟล์ Zip",
  "filetype_zip": "ไฟล์ Zip",
  "olefile": "ไฟล์ OLE",
  "filetype_olefile": "ไฟล์ OLE",
  "gmailmessage": "ข้อความ Gmail",
  "filetype_gmailmessage": "ข้อความ Gmail",
  "pdf": "ไฟล์ PDF",
  "filetype_pdf": "ไฟล์ PDF",
  "swf": "ไฟล์ Flash",
  "filetype_swf": "ไฟล์ Flash",
  "xml": "ไฟล์ XML",
  "filetype_xml": "ไฟล์ XML",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "เปิด Office",
  "filetype_svm": "เปิด Office",
  "rssitem": "ฟีด RSS",
  "filetype_rssitem": "ฟีด RSS",
  "doc": "เอกสาร",
  "filetype_doc": "เอกสาร",
  "docx": "เอกสาร Microsoft Word",
  "filetype_docx": "เอกสาร Microsoft Word",
  "xls": "เอกสารสเปรดชีท",
  "filetype_xls": "เอกสารสเปรดชีท",
  "ppt": "เอกสารการนำเสนอ",
  "filetype_ppt": "เอกสารการนำเสนอ",
  "video": "วิดีโอ",
  "filetype_video": "วิดีโอ",
  "saleforceitem": "Salesforce",
  "filetype_saleforceitem": "Salesforce",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "Salesforce",
  "filetype_salesforceitem": "Salesforce",
  "odt": "เปิดเอกสารข้อความ",
  "filetype_odt": "เปิดเอกสารข้อความ",
  "lithiummessage": "ข้อความ Lithium",
  "filetype_lithiummessage": "ข้อความ Lithium",
  "lithiumthread": "เธรด Lithium",
  "filetype_lithiumthread": "เธรด Lithium",
  "lithiumboard": "บอร์ด Lithium",
  "filetype_lithiumboard": "บอร์ด Lithium",
  "lithiumcategory": "หมวดหมู่ Lithium",
  "filetype_lithiumcategory": "หมวดหมู่ Lithium",
  "lithiumcommunity": "ชุมชน Lithium",
  "filetype_lithiumcommunity": "ชุมชน Lithium",
  "people": "ผู้ใช้",
  "objecttype_people": "ผู้ใช้",
  "message": "ข้อความ",
  "objecttype_message": "ข้อความ",
  "feed": "ฟีด RSS",
  "objecttype_feed": "ฟีด RSS",
  "thread": "เธรด",
  "objecttype_thread": "เธรด",
  "file": "ไฟล์",
  "objecttype_file": "ไฟล์",
  "board": "บอร์ด",
  "objecttype_board": "บอร์ด",
  "category": "หมวดหมู่",
  "objecttype_category": "หมวดหมู่",
  "account": "บัญชี",
  "objecttype_account": "บัญชี",
  "annotation": "หมายเหตุ",
  "objecttype_annotation": "หมายเหตุ",
  "campaign": "แคมเปญ",
  "objecttype_campaign": "แคมเปญ",
  "case": "กรณี",
  "objecttype_case": "กรณี",
  "contact": "ติดต่อ",
  "objecttype_contact": "ติดต่อ",
  "contract": "สัญญา",
  "objecttype_contract": "สัญญา",
  "event": "กิจกรรม",
  "objecttype_event": "กิจกรรม",
  "email": "อีเมล",
  "objecttype_email": "อีเมล",
  "goal": "เป้าหมาย",
  "objecttype_goal": "เป้าหมาย",
  "incident": "กรณี",
  "objecttype_incident": "กรณี",
  "invoice": "ใบแจ้งหนี้",
  "objecttype_invoice": "ใบแจ้งหนี้",
  "lead": "ลีด",
  "objecttype_lead": "ลีด",
  "list": "รายการ",
  "objecttype_list": "รายการด้านการตลาด",
  "solution": "โซลูชัน",
  "objecttype_solution": "โซลูชัน",
  "task": "งาน",
  "objecttype_task": "งาน",
  "user": "ผู้ใช้",
  "objecttype_user": "ผู้ใช้",
  "attachment": "เอกสารแนบ",
  "objecttype_attachment": "เอกสารแนบ",
  "casecomment": "ข้อคิดเห็นต่อกรณี",
  "objecttype_casecomment": "ข้อคิดเห็นต่อกรณี",
  "opportunity": "โอกาส",
  "objecttype_opportunity": "โอกาส",
  "opportunityproduct": "ผลิตภัณฑ์ที่มีโอกาส",
  "objecttype_opportunityproduct": "ผลิตภัณฑ์ที่มีโอกาส",
  "feeditem": "Chatter",
  "objecttype_feeditem": "Chatter",
  "feedcomment": "Chatter",
  "objecttype_feedcomment": "Chatter",
  "note": "หมายเหตุ",
  "objecttype_note": "หมายเหตุ",
  "product": "ผลิตภัณฑ์",
  "objecttype_product": "ผลิตภัณฑ์",
  "partner": "พันธมิตร",
  "objecttype_partner": "พันธมิตร",
  "queueitem": "รายการคิว",
  "objecttype_queueitem": "รายการคิว",
  "quote": "แจ้งราคา",
  "objecttype_quote": "แจ้งราคา",
  "salesliterature": "การบันทึกข้อมูลที่ได้ติดต่อลูกค้า",
  "objecttype_salesliterature": "การบันทึกข้อมูลที่ได้ติดต่อลูกค้า",
  "salesorder": "คำสั่งขาย",
  "objecttype_salesorder": "คำสั่งขาย",
  "service": "บริการ",
  "objecttype_service": "บริการ",
  "socialprofile": "โปรไฟล์สังคม",
  "objecttype_socialprofile": "โปรไฟล์สังคม",
  "kbdocumentation": "เอกสารประกอบ",
  "objecttype_kbdocumentation": "เอกสารประกอบ",
  "kbtechnicalarticle": "เอกสารประกอบ",
  "objecttype_kbtechnicalarticle": "เอกสารประกอบ",
  "kbsolution": "โซลูชัน",
  "objecttype_kbsolution": "โซลูชัน",
  "kbknowledgearticle": "บทความให้ความรู้",
  "objecttype_kbknowledgearticle": "บทความให้ความรู้",
  "kbattachment": "เอกสารแนบ",
  "objecttype_kbattachment": "เอกสารแนบ",
  "kbarticle": "บทความ",
  "objecttype_kbarticle": "บทความ",
  "kbarticlecomment": "ข้อคิดเห็นในบทความ",
  "objecttype_kbarticlecomment": "ข้อคิดเห็นในบทความ",
  "knowledgearticle": "บทความให้ความรู้",
  "objecttype_knowledgearticle": "บทความให้ความรู้",
  "topic": "หัวข้อ",
  "objecttype_topic": "หัวข้อ",
  "dashboard": "แดชบอร์ด",
  "objecttype_dashboard": "แดชบอร์ด",
  "contentversion": "เอกสาร",
  "objecttype_contentversion": "เอกสาร",
  "collaborationgroup": "กลุ่มความร่วมมือ",
  "objecttype_collaborationgroup": "กลุ่มความร่วมมือ",
  "spportal": "พอร์ทัล",
  "filetype_spportal": "พอร์ทัล",
  "spsite": "ไซต์",
  "filetype_spsite": "ไซต์",
  "spuserprofile": "ผู้ใช้ SharePoint",
  "filetype_spuserprofile": "ผู้ใช้ SharePoint",
  "sparea": "พื้นที่",
  "filetype_sparea": "พื้นที่",
  "spannouncement": "คำประกาศ",
  "filetype_spannouncement": "คำประกาศ",
  "spannouncementlist": "คำประกาศ",
  "filetype_spannouncementlist": "คำประกาศ",
  "spcontact": "ติดต่อ",
  "filetype_spcontact": "ติดต่อ",
  "spcontactlist": "ผู้ติดต่อ",
  "filetype_spcontactlist": "ผู้ติดต่อ",
  "spcustomlist": "รายการแบบกำหนดเอง",
  "filetype_spcustomlist": "รายการแบบกำหนดเอง",
  "spdiscussionboard": "กระดานสนทนา",
  "filetype_spdiscussionboard": "กระดานสนทนา",
  "spdiscussionboardlist": "กระดานสนทนา",
  "filetype_spdiscussionboardlist": "กระดานสนทนา",
  "spdocumentlibrarylist": "คลังเอกสาร",
  "filetype_spdocumentlibrarylist": "คลังเอกสาร",
  "spevent": "กิจกรรม",
  "filetype_spevent": "กิจกรรม",
  "speventlist": "กิจกรรม",
  "filetype_speventlist": "กิจกรรม",
  "spformlibrarylist": "ึคลังรูปแบบ",
  "filetype_spformlibrarylist": "ึคลังรูปแบบ",
  "spissue": "ปัญหา",
  "filetype_spissue": "ปัญหา",
  "spissuelist": "ปัญหา",
  "filetype_spissuelist": "ปัญหา",
  "splink": "ลิงก์",
  "filetype_splink": "ลิงก์",
  "splinklist": "ลิงก์",
  "filetype_splinklist": "ลิงก์",
  "sppicturelibrarylist": "คลังรูปภาพ",
  "filetype_sppicturelibrarylist": "คลังรูปภาพ",
  "spsurvey": "การสำรวจ",
  "filetype_spsurvey": "การสำรวจ",
  "spsurveylist": "การสำรวจ",
  "filetype_spsurveylist": "การสำรวจ",
  "sptask": "งาน",
  "filetype_sptask": "งาน",
  "sptasklist": "งาน",
  "filetype_sptasklist": "งาน",
  "spagenda": "ระเบียบวาระ",
  "filetype_spagenda": "ระเบียบวาระ",
  "spagendalist": "ระเบียบวาระ",
  "filetype_spagendalist": "ระเบียบวาระ",
  "spattendee": "ผู้เข้าร่วม",
  "filetype_spattendee": "ผู้เข้าร่วม",
  "spattendeelist": "ผู้เข้าร่วม",
  "filetype_spattendeelist": "ผู้เข้าร่วม",
  "spcustomgridlist": "กริดแบบกำหนดเอง",
  "filetype_spcustomgridlist": "กริดแบบกำหนดเอง",
  "spdecision": "การตัดสินใจ",
  "filetype_spdecision": "การตัดสินใจ",
  "spdecisionlist": "การตัดสินใจ",
  "filetype_spdecisionlist": "การตัดสินใจ",
  "spobjective": "วัตถุประสงค์",
  "filetype_spobjective": "วัตถุประสงค์",
  "spobjectivelist": "วัตถุประสงค์",
  "filetype_spobjectivelist": "วัตถุประสงค์",
  "sptextbox": "กล่องข้อความ",
  "filetype_sptextbox": "กล่องข้อความ",
  "sptextboxlist": "รายการกล่องข้อความ",
  "filetype_sptextboxlist": "รายการกล่องข้อความ",
  "spthingstobring": "สิ่งที่จะต้องนำเสนอ",
  "filetype_spthingstobring": "สิ่งที่จะต้องนำเสนอ",
  "spthingstobringlist": "สิ่งที่จะต้องนำเสนอ",
  "filetype_spthingstobringlist": "สิ่งที่จะต้องนำเสนอ",
  "sparealisting": "รายการพื้นที่",
  "filetype_sparealisting": "รายการพื้นที่",
  "spmeetingserie": "ลำดับการประชุม",
  "filetype_spmeetingserie": "ลำดับการประชุม",
  "spmeetingserielist": "รายการลำดับการประชุม",
  "filetype_spmeetingserielist": "รายการลำดับการประชุม",
  "spsitedirectory": "รายการไดเร็กทอรีของไซต์",
  "filetype_spsitedirectory": "รายการไดเร็กทอรีของไซต์",
  "spsitedirectorylist": "ไดเร็กทอรีของไซต์",
  "filetype_spsitedirectorylist": "ไดเร็กทอรีของไซต์",
  "spdatasource": "แหล่งข้อมูล",
  "filetype_spdatasource": "แหล่งข้อมูล",
  "spdatasourcelist": "รายการแหล่งข้อมูล",
  "filetype_spdatasourcelist": "รายการแหล่งข้อมูล",
  "splisttemplatecataloglist": "แกลเลอรีเท็มเพลตของรายการ",
  "filetype_splisttemplatecataloglist": "แกลเลอรีเท็มเพลตของรายการ",
  "spwebpartcataloglist": "แกลเลอรี WebPart",
  "filetype_spwebpartcataloglist": "แกลเลอรี WebPart",
  "spwebtemplatecataloglist": "แกลเลอรีเท็มเพลตของไซต์",
  "filetype_spwebtemplatecataloglist": "แกลเลอรีเท็มเพลตของไซต์",
  "spworkspacepagelist": "หน้า Workspace",
  "filetype_spworkspacepagelist": "หน้า Workspace",
  "spunknownlist": "รายการแบบกำหนดเอง",
  "filetype_spunknownlist": "รายการแบบกำหนดเอง",
  "spadministratortask": "งานของผู้ดูแล",
  "filetype_spadministratortask": "งานของผู้ดูแล",
  "spadministratortasklist": "งานของผู้ดูแล",
  "filetype_spadministratortasklist": "งานของผู้ดูแล",
  "spareadocumentlibrarylist": "คลังเอกสารเกี่ยวกับพื้นที่",
  "filetype_spareadocumentlibrarylist": "คลังเอกสารเกี่ยวกับพื้นที่",
  "spblogcategory": "หมวดหมู่บล็อก",
  "filetype_spblogcategory": "หมวดหมู่บล็อก",
  "spblogcategorylist": "หมวดหมู่บล็อก",
  "filetype_spblogcategorylist": "หมวดหมู่บล็อก",
  "spblogcomment": "ข้อคิดเห็นในบล็อก",
  "filetype_spblogcomment": "ข้อคิดเห็นในบล็อก",
  "spblogcommentlist": "ข้อคิดเห็นในบล็อก",
  "filetype_spblogcommentlist": "ข้อคิดเห็นในบล็อก",
  "spblogpost": "โพสต์ในบล็อก",
  "filetype_spblogpost": "โพสต์ในบล็อก",
  "spblogpostlist": "โพสต์ในบล็อก",
  "filetype_spblogpostlist": "โพสต์ในบล็อก",
  "spdataconnectionlibrarylist": "คลังการเชื่อมโยงข้อมูล",
  "filetype_spdataconnectionlibrarylist": "คลังการเชื่อมโยงข้อมูล",
  "spdistributiongroup": "กลุ่มการกระจาย",
  "filetype_spdistributiongroup": "กลุ่มการกระจาย",
  "spdistributiongrouplist": "กลุ่มการกระจาย",
  "filetype_spdistributiongrouplist": "กลุ่มการกระจาย",
  "spipfslist": "InfoPath Forms Servers",
  "filetype_spipfslist": "InfoPath Forms Servers",
  "spkeyperformanceindicator": "ตัวชี้วัดผลการปฏิบัติงานหลัก",
  "filetype_spkeyperformanceindicator": "ตัวชี้วัดผลการปฏิบัติงานหลัก",
  "spkeyperformanceindicatorlist": "ตัวชี้วัดผลการปฏิบัติงานหลัก",
  "filetype_spkeyperformanceindicatorlist": "ตัวชี้วัดผลการปฏิบัติงานหลัก",
  "splanguagesandtranslator": "ภาษาและผู้แปล",
  "filetype_splanguagesandtranslator": "ภาษาและผู้แปล",
  "splanguagesandtranslatorlist": "ภาษาและผู้แปล",
  "filetype_splanguagesandtranslatorlist": "ภาษาและผู้แปล",
  "spmasterpagescataloglist": "แกลเลอรีเพจหลัก",
  "filetype_spmasterpagescataloglist": "แกลเลอรีเพจหลัก",
  "spnocodeworkflowlibrarylist": "คลังขั้นตอนการทำงานแบบไม่มีรหัส",
  "filetype_spnocodeworkflowlibrarylist": "คลังขั้นตอนการทำงานแบบไม่มีรหัส",
  "spprojecttask": "งานในโครงการ",
  "filetype_spprojecttask": "งานในโครงการ",
  "spprojecttasklist": "งานในโครงการ",
  "filetype_spprojecttasklist": "งานในโครงการ",
  "sppublishingpageslibrarylist": "คลังของเพจ",
  "filetype_sppublishingpageslibrarylist": "คลังของเพจ",
  "spreportdocumentlibrarylist": "คลังเอกสารรายงาน",
  "filetype_spreportdocumentlibrarylist": "คลังเอกสารรายงาน",
  "spreportlibrarylist": "คลังรายงาน",
  "filetype_spreportlibrarylist": "คลังรายงาน",
  "spslidelibrarylist": "คลังสไลด์",
  "filetype_spslidelibrarylist": "คลังสไลด์",
  "sptab": "ปุ่มแท็บ",
  "filetype_sptab": "ปุ่มแท็บ",
  "sptablist": "รายการแท็บ",
  "filetype_sptablist": "รายการแท็บ",
  "sptranslationmanagementlibrarylist": "คลังการจัดการการแปล",
  "filetype_sptranslationmanagementlibrarylist": "คลังการจัดการการแปล",
  "spuserinformation": "ข้อมูลผู้ใช้",
  "filetype_spuserinformation": "ข้อมูลผู้ใช้",
  "spuserinformationlist": "รายการข้อมูลผู้ใช้",
  "filetype_spuserinformationlist": "รายการข้อมูลผู้ใช้",
  "spwikipagelibrarylist": "คลังเพจ Wiki",
  "filetype_spwikipagelibrarylist": "คลังเพจ Wiki",
  "spworkflowhistory": "ประวัติขั้นตอนการทำงาน",
  "filetype_spworkflowhistory": "ประวัติขั้นตอนการทำงาน",
  "spworkflowhistorylist": "รายการประวัติขั้นตอนการทำงาน",
  "filetype_spworkflowhistorylist": "รายการประวัติขั้นตอนการทำงาน",
  "spworkflowprocess": "ขั้นตอนการทำงานแบบกำหนดเอง",
  "filetype_spworkflowprocess": "ขั้นตอนการทำงานแบบกำหนดเอง",
  "spworkflowprocesslist": "ขั้นตอนการทำงานแบบกำหนดเอง",
  "filetype_spworkflowprocesslist": "ขั้นตอนการทำงานแบบกำหนดเอง",
  "sppublishingimageslibrarylist": "คลังรูปภาพสำหรับการเผยแพร่",
  "filetype_sppublishingimageslibrarylist": "คลังรูปภาพสำหรับการเผยแพร่",
  "spcirculation": "การเผยแพร่",
  "filetype_spcirculation": "การเผยแพร่",
  "spcirculationlist": "การเผยแพร่",
  "filetype_spcirculationlist": "การเผยแพร่",
  "spdashboardslibrarylist": "คลังแดชบอร์ด",
  "filetype_spdashboardslibrarylist": "คลังแดชบอร์ด",
  "spdataconnectionforperformancepointlibrarylist": "คลังการเชื่อมโยงข้อมูล PerformancePoint",
  "filetype_spdataconnectionforperformancepointlibrarylist": "คลังการเชื่อมโยงข้อมูล PerformancePoint",
  "sphealthreport": "รายงานสุขภาพ",
  "filetype_sphealthreport": "รายงานสุขภาพ",
  "sphealthreportlist": "รายงานสุขภาพ",
  "filetype_sphealthreportlist": "รายงานสุขภาพ",
  "sphealthrule": "กฎเกี่ยวกับสุขภาพ",
  "filetype_sphealthrule": "กฎเกี่ยวกับสุขภาพ",
  "sphealthrulelist": "กฎเกี่ยวกับสุขภาพ",
  "filetype_sphealthrulelist": "กฎเกี่ยวกับสุขภาพ",
  "spimedictionary": "พจนานุกรม IME",
  "filetype_spimedictionary": "พจนานุกรม IME",
  "spimedictionarylist": "พจนานุกรม IME",
  "filetype_spimedictionarylist": "พจนานุกรม IME",
  "spperformancepointcontent": "เนื้อหา PerformancePoint",
  "filetype_spperformancepointcontent": "เนื้อหา PerformancePoint",
  "spperformancepointcontentlist": "เนื้อหา PerformancePoint",
  "filetype_spperformancepointcontentlist": "เนื้อหา PerformancePoint",
  "spphonecallmemo": "บันทึกการโทร",
  "filetype_spphonecallmemo": "บันทึกการโทร",
  "spphonecallmemolist": "บันทึกการโทร",
  "filetype_spphonecallmemolist": "บันทึกการโทร",
  "sprecordlibrarylist": "คลังบันทึก",
  "filetype_sprecordlibrarylist": "คลังบันทึก",
  "spresource": "ทรัพยากร",
  "filetype_spresource": "ทรัพยากร",
  "spresourcelist": "ทรัพยากร",
  "filetype_spresourcelist": "ทรัพยากร",
  "spprocessdiagramslibrarylist": "คลังแผนภาพขั้นตอน",
  "filetype_spprocessdiagramslibrarylist": "คลังแผนภาพขั้นตอน",
  "spsitethemeslibrarylist": "ึคลังธีมของไซต์",
  "filetype_spsitethemeslibrarylist": "ึคลังธีมของไซต์",
  "spsolutionslibrarylist": "คลังโซลูชัน",
  "filetype_spsolutionslibrarylist": "คลังโซลูชัน",
  "spwfpublibrarylist": "คลัง WFPUB",
  "filetype_spwfpublibrarylist": "คลัง WFPUB",
  "spwhereabout": "ตำแหน่งที่ตั้ง",
  "filetype_spwhereabout": "ตำแหน่งที่ตั้ง",
  "spwhereaboutlist": "ตำแหน่งที่ตั้ง",
  "filetype_spwhereaboutlist": "ตำแหน่งที่ตั้ง",
  "spdocumentlink": "เชื่อมโยงไปยังเอกสาร",
  "filetype_spdocumentlink": "เชื่อมโยงไปยังเอกสาร",
  "spdocumentset": "ชุดเอกสาร",
  "filetype_spdocumentset": "ชุดเอกสาร",
  "spmicrofeedpost": "โพสต์ใน Microfeed",
  "filetype_spmicrofeedpost": "โพสต์ใน Microfeed",
  "spmicrofeedlist": "Microfeed",
  "filetype_spmicrofeedlist": "Microfeed",
  "splistfolder": "โฟลเดอร์รายการ",
  "filetype_splistfolder": "โฟลเดอร์รายการ",
  "Unknown": "ที่ไม่รู้จัก",
  "And": "และ",
  "Authenticating": "กำลังพิสูจน์ความถูกต้องของ {0}...",
  "Clear": "ล้าง {0}",
  "CompleteQuery": "คิวรีทั้งหมด",
  "Exclude": "ไม่รวม {0}",
  "EnterTag": "เพิ่มแท็ก",
  "Next": "ถัดไป",
  "Last": "ท้ายสุด",
  "Link": "ลิงก์",
  "Or": "หรือ",
  "Previous": "ก่อนหน้า",
  "QueryDidntMatchAnyDocuments": "คิวรีของคุณไม่ตรงกับเอกสารใดๆ",
  "QueryException": "คิวรีของคุณมีข้อผิดพลาด: {0}",
  "Me": "ฉัน",
  "Remove": "นำออก",
  "Search": "ค้นหา",
  "SearchFor": "ค้นหา {0}",
  "ShareQuery": "แบ่งปันคิวรี",
  "Preferences": "ลักษณะที่ต้องการ",
  "LinkOpeningSettings": "การตั้งค่าการเปิดลิงก์",
  "Reauthenticate": "พิสูจน์ความถูกต้องของ {0} ใหม่อีกครั้ง",
  "ResultsFilteringExpression": "นิพจน์การกรองผลลัพธ์",
  "FiltersInYourPreferences": "ตัวกรองในลักษณะที่ต้องการของคุณ",
  "Create": "สร้าง",
  "SearchIn": "ค้นหาใน {0}",
  "Seconds": "ใน {0} วินาที",
  "ShowingResultsOf": "ผลลัพธ์ที่ {0}<pl>-{1}</pl> จาก {2}",
  "ShowingResultsOfWithQuery": "ผลลัพธ์ที่ {0}<pl>-{1}</pl> จาก {2}",
  "SwitchTo": "เปลี่ยนเป็น {0}",
  "Unexclude": "ไม่แยก {0}",
  "ClearAllFilters": "ล้างตัวกรองทั้งหมด",
  "SkipLogin": "ข้ามการลงชื่อเข้าใช้",
  "LoginInProgress": "กำลังลงชื่อเข้าใช้ โปรดรอ...",
  "Login": "ลงชื่อเข้าใช้",
  "GetStarted": "เริ่มต้น",
  "More": "เพิ่มเติม",
  "NMore": "{0} เพิ่มเติม...",
  "Less": "น้อยลง",
  "Settings": "การตั้งค่า",
  "Score": "คะแนน",
  "ScoreDescription": "คำนวณคะแนนจากจำนวนครั้งของเหตุการณ์ที่เกิดรวมถึงตำแหน่งในชุดผลลัพธ์",
  "Occurrences": "เหตุการณ์ที่เกิด",
  "OccurrencesDescription": "จัดเรียงตามจำนวนครั้งของเหตุการณ์ที่เกิดจากมากสุดไปหาน้อยสุด",
  "Label": "ป้าย",
  "Of": "ของ",
  "LabelDescription": "จัดเรียงตามลำดับอักษรในค่าฟิลด์",
  "Value": "ค่า",
  "ValueDescription": "จัดเรียงตามค่าของฟิลด์ที่คำนวณก่อน",
  "AlphaAscending": "ค่าน้อยไปมาก",
  "AlphaDescending": "ค่ามากไปน้อย",
  "ChiSquare": "ไคสแควร์",
  "Nosort": "ไม่มีการจัดเรียง",
  "NosortDescription": "ห้ามจัดเรียงค่า ค่าจะถูกส่งกลับในลำดับแบบสุ่ม",
  "RelativeFrequency": "ความถี่สัมพัทธ์",
  "RelativeFrequencyDescription": "จัดเรียงตามความถี่สัมพัทธ์ของค่า โดยค่าที่มีความถี่น้อยที่สุดจะปรากฎอยู่บนสุด",
  "DateDistribution": "การแจกแจงวัน",
  "Custom": "กำหนดเอง",
  "CustomDescription": "จัดเรียงตามลำดับที่กำหนดเอง",
  "ComputedField": "ฟิลด์ที่คำนวณ",
  "Ascending": "มากไปหาน้อย",
  "Descending": "น้อยไปหามาก",
  "noResultFor": "ไม่พบผลลัพธ์สำหรับ {0}",
  "autoCorrectedQueryTo": "คิวรีได้รับการแก้ไขโดยอัตโนมัติเป็น {0}",
  "didYouMean": "คุณหมายถึง: {0} หรือไม่",
  "SuggestedResults": "ผลลัพธ์ที่แนะนำ",
  "SuggestedQueries": "คิวรีที่แนะนำ",
  "MostRelevantItems": "รายการที่เกี่ยวข้องที่สุด:",
  "AllItems": "รายการทั้งหมด:",
  "ShowLess": "แสดงน้อยลง",
  "ShowMore": "แสดงเพิ่มขึ้น",
  "HideFacet": "ซ่อนแฟเซ็ท",
  "ShowFacet": "แสดงแฟเซ็ท",
  "AndOthers": "และ{0}อื่น<pl>ๆ</pl>",
  "Others": "{0}อื่น<pl>ๆ</pl>",
  "MostRelevantPosts": "โพสต์ที่เกี่ยวข้องที่สุด:",
  "CompleteThread": "กระทู้แบบสมบูรณ์:",
  "ShowCompleteThread": "แสดงกระทู้แบบสมบูรณ์",
  "ShowOnlyTopMatchingPosts": "แสดงเฉพาะกระทู้ที่ตรงที่สุดเท่านั้น",
  "MostRelevantReplies": "การตอบกลับที่เกี่ยวข้องที่สุด:",
  "AllConversation": "บทสนทนาทั้งหมด:",
  "ShowAllConversation": "แสดงบทสนทนาทั้งหมด",
  "ShowAllReplies": "แสดงการตอบกลับทั้งหมด",
  "ShowOnlyMostRelevantReplies": "แสดงเฉพาะการตอบกลับที่เกี่ยวข้องที่สุดเท่านั้น",
  "Close": "ปิด",
  "Open": "เปิด",
  "OpenInOutlookWhenPossible": "เปิดใน Outlook (เมื่อสามารถทำได้)",
  "AlwaysOpenInNewWindow": "เปิดผลลัพธ์ในหน้าต่างใหม่เสมอ",
  "Quickview": "มุมมองด่วน",
  "NoQuickview": "มุมมองด่วนสำหรับเอกสารนี้ไม่พร้อมใช้งาน",
  "ErrorReport": "การรายงานข้อผิดพลาด",
  "OopsError": "เกิดข้อผิดพลาดบางอย่างกับเซิร์ฟเวอร์",
  "ProblemPersists": "หากปัญหายังคงอยู่ โปรดติดต่อผู้ดูแล",
  "GoBack": "ย้อนกลับ",
  "Reset": "รีเซ็ต",
  "Retry": "ลองใหม่",
  "MoreInfo": "ข้อมูลเพิ่มเติม",
  "Username": "ชื่อผู้ใช้",
  "Password": "รหัสผ่าน",
  "PostedBy": "โพสต์โดย",
  "CannotConnect": "ไม่สามารถเชื่อมต่อที่อยู่เซิร์ฟเวอร์ได้",
  "BadUserPass": "รหัสผ่านไม่ตรงกับชื่อผู้ใช้",
  "PleaseEnterYourCredentials": "โปรดกรอกหลักฐานอ้างอิงของคุณสำหรับ {0}",
  "PleaseEnterYourSearchPage": "โปรดกรอก URL หน้าการค้นหาของคุณ",
  "Collapse": "ยุบ",
  "Collapsable": "ยุบได้",
  "Expand": "ขยาย",
  "Today": "วันนี้",
  "Yesterday": "เมื่อวาน",
  "Tomorrow": "พรุ่งนี้",
  "Duration": "ระยะเวลา: {0}",
  "IndexDuration": "ระยะเวลาของดัชนี: {0}",
  "ProxyDuration": "ระยะเวลาของพร็อกซี่: {0}",
  "ClientDuration": "ระยะเวลาของไคลเอนต์: {0}",
  "Unavailable": "ไม่มี",
  "Reply": "ตอบกลับ",
  "ReplyAll": "ตอบกลับทั้งหมด",
  "Forward": "ส่งต่อ",
  "From": "จาก",
  "Caption": "หัวข้อ",
  "Expression": "นิพจน์",
  "Tab": "ปุ่มแท็บ",
  "Tabs": "ปุ่มแท็บ",
  "EnterExpressionName": "ป้อนชื่อนิพจน์",
  "EnterExpressionToFilterWith": "ป้อนนิพจน์เพื่อกรองผลลัพธ์",
  "SelectTab": "เลือกปุ่มแท็บ",
  "SelectAll": "เลือกทั้งหมด",
  "PageUrl": "เลือก URL หน้า",
  "ErrorSavingToDevice": "เกิดข้อผิดพลาดขณะบันทึกข้อมูลลงในอุปกรณ์ของคุณ",
  "ErrorReadingFromDevice": "เกิดข้อผิดพลาดขณะอ่านข้อมูลจากอุปกรณ์ของคุณ",
  "AppIntro": "พูดคุยกับผู้เชี่ยวชาญด้านผลิตภัณฑ์ซึ่งสามารถตอบคำถามของคุณเกี่ยวกับ Coveo และช่วยคุณตัดสินใจว่าโซลูชัน Coveo ใดที่เหมาะสมกับคุณ หรือทดลองใช้ผลิตภัณฑ์ตัวอย่าง!",
  "TryDemo": "ทดลองใช้ตัวอย่าง",
  "ContactUs": "ติดต่อเรา",
  "NewToCoveo": "เพิ่งเริ่มใช้ Coveo ใช่ไหม",
  "LetUsHelpGetStarted": "ให้เราช่วยคุณในการเริ่มต้น",
  "LikesThis": "{0} ถูกใจ สิ่งนี้",
  "CannotConnectSearchPage": "ไม่สามารถเชื่อมต่อหน้าการค้นหาของคุณได้",
  "AreYouSureDeleteFilter": "คุณแน่ใจหรือไม่ว่าคุณต้องการลบตัวกรอง {0} ที่มีนิพจน์ {1}",
  "OnlineHelp": "ความช่วยเหลือออนไลน์",
  "Done": "เสร็จเรียบร้อย",
  "SaveFacetState": "บันทึกสถานะแฟเซ็ทนี้",
  "ClearFacetState": "ล้างสถานะแฟเซ็ท",
  "DisplayingTheOnlyMessage": "แสดงเฉพาะข้อความในการสนทนานี้",
  "NoNetworkConnection": "ไม่มีการเชื่อมต่อเครือข่าย",
  "UnknownConnection": "การเชื่อมต่อที่ไม่รู้จัก",
  "EthernetConnection": "การเชื่อมต่ออีเทอร์เน็ต",
  "WiFi": "การเชื่อมต่อ WiFi",
  "CELL": "การเชื่อมต่อเซลลูลาร์",
  "CELL_2G": "การเชื่อมต่อเซลลูลาร์ 2 จี",
  "CELL_3G": "การเชื่อมต่อเซลลูลาร์ 3 จี",
  "CELL_4G": "การเชื่อมต่อเซลลูลาร์ 4 จี",
  "Relevance": "ความสัมพันธ์กัน",
  "Date": "วัน",
  "Amount": "จำนวน",
  "QueryExceptionNoException": "ไม่มีสิ่งผิดปกติ",
  "QueryExceptionInvalidSyntax": "ซินแท็กซ์ไม่ถูกต้อง",
  "QueryExceptionInvalidCustomField": "ฟิลด์กำหนดเองไม่ถูกต้อง",
  "QueryExceptionInvalidDate": "วันไม่ถูกต้อง",
  "QueryExceptionInvalidExactPhrase": "วลีแบบตรงทั้งหมดไม่ถูกต้อง",
  "QueryExceptionInvalidDateOp": "ตัวปฏิบัติการวันไม่ถูกต้อง",
  "QueryExceptionInvalidNear": "ตัวปฏิบัติการ NEAR ไม่ถูกต้อง",
  "QueryExceptionInvalidWeightedNear": "NEAR ถ่วงน้ำหนักไม่ถูกต้อง",
  "QueryExceptionInvalidTerm": "คำศัพท์ไม่ถูกต้อง",
  "QueryExceptionTooManyTerms": "มีคำศัพท์มากเกินไป",
  "QueryExceptionWildcardTooGeneral": "อักขรแทนกว้างเกินไป",
  "QueryExceptionInvalidSortField": "ฟิลด์จัดเรียงไม่ถูกต้อง",
  "QueryExceptionInvalidSmallStringOp": "ตัวปฏิบัติการสตริงเล็กไม่ถูกต้อง",
  "QueryExceptionRequestedResultsMax": "จำนวนสูงสุดของผลลัพธ์ที่ร้องขอ",
  "QueryExceptionAggregatedMirrorDead": "ดัชนีระยะไกลออฟไลน์",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "คิวรีดัชนีระยะไกลหมดเวลา",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "หมายเลขสร้างดัชนีระยะไกลไม่ถูกต้อง",
  "QueryExceptionAggregatedMirrorCannotConnect": "ดัชนีระยะไกลไม่สามารถเชื่อมต่อได้",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "อักขรแทนมีอักษรนำไม่เพียงพอ",
  "QueryExceptionSecurityInverterNotFound": "ไม่พบตัวผกผันเพื่อความปลอดภัย",
  "QueryExceptionSecurityInverterAccessDenied": "การเข้าถึงตัวผกผันเพื่อความปลอดภัยถูกปฏิเสธ",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "ดัชนีระยะไกลไม่สามารถเลียนแบบได้",
  "QueryExceptionUnexpected": "ที่ไม่คาดคิด",
  "QueryExceptionAccessDenied": "การเข้าถึงถูกปฏิเสธ",
  "QueryExceptionSuperUserTokenInvalid": "โทเคนของซูเปอร์ยูสเซอร์ไม่ถูกต้อง",
  "QueryExceptionSuperUserTokenExpired": "โทเคนของซูเปอร์ยูสเซอร์หมดอายุ",
  "QueryExceptionLicenseQueriesExpired": "ใบอนุญาตคิวรีหมดอายุแล้ว",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "ไม่สนับสนุนโทเคนของซูเปอร์ยูสเซอร์ของใบอนุญาต",
  "QueryExceptionInvalidSession": "เซสชันไม่ถูกต้อง",
  "QueryExceptionInvalidDocument": "เอกสารไม่ถูกต้อง",
  "QueryExceptionSearchDisabled": "ปิดการค้นหา",
  "FileType": "ประเภทไฟล์",
  "ShowAttachment": "แสดงเอกสารแนบ",
  "OnFeed": "บนฟีดของ {0}",
  "Author": "ผู้สร้าง",
  "NoTitle": "ไม่มีชื่อ",
  "CurrentSelections": "รายการที่เลือกในปัจจุบัน",
  "AllContent": "เนื้อหาทั้งหมด",
  "CancelLastAction": "ยกเลิกการกระทำล่าสุด",
  "SearchTips": "เคล็ดลับการค้นหา",
  "CheckSpelling": "ตรวจสอบตัวสะกดของคำสำคัญของคุณ",
  "TryUsingFewerKeywords": "ลองใช้คำสำคัญที่น้อยลง แตกต่าง หรือมีความหมายกว้างขึ้น",
  "SelectFewerFilters": "เลือกตัวกรองให้น้อยลงเพื่อขยายขอบเขตการค้นหาของคุณ",
  "Document": "เอกสาร",
  "Time": "เวลา",
  "StartDate": "วันที่เริ่มต้น",
  "StartTime": "เวลาเริ่มต้น",
  "DurationTitle": "ระยะเวลา",
  "UserQuery": "คิวรีของผู้ใช้",
  "ShowUserActions": "แสดงการดำเนินการของผู้ใช้",
  "NoData": "ไม่มีข้อมูลที่ใช้ได้",
  "EventType": "ประเภทกิจกรรม",
  "GoToFullSearch": "การค้นหาทั้งหมด",
  "GoToEdition": "กำหนดแผงเอง",
  "RemoveContext": "นำบริบทออก",
  "BoxAttachToCase": "แนบไปที่กรณี",
  "AttachToCase": "แนบไปที่กรณี",
  "Attach": "แนบ",
  "Attached": "แนบแล้ว",
  "Detach": "ถอดออก",
  "Details": "รายละเอียด",
  "AdditionalFilters": "ตัวกรองเพิ่มเติม",
  "SelectNonContextualSearch": "นำบริบทออกจากเร็กคอร์ดปัจจุบันเพื่อขยายการค้นหาของคุณ",
  "CopyPasteToSupport": "คัดลอกและวางข้อความนี้สำหรับทีมสนับสนุน Coveo สำหรับข้อมูลเพิ่มเติม",
  "FollowQueryDescription": "แจ้งฉันสำหรับการเปลี่ยนแปลงในผลการค้นหาของคิวรีนี้",
  "SearchAlerts_Panel": "จัดการการแจ้งเตือน",
  "SearchAlerts_PanelDescription": "ดูและจัดการการแจ้งเตือนการค้นหาของคุณ",
  "SearchAlerts_PanelNoSearchAlerts": "คุณไม่ได้สมัครสมาชิก",
  "SearchAlerts_Fail": "บริการแจ้งเตือนการค้นหาไม่พร้อมใช้งานในขณะนี้",
  "SearchAlerts_Type": "ประเภท",
  "SearchAlerts_Content": "เนื้อหา",
  "SearchAlerts_Actions": "การกระทำ",
  "EmptyQuery": "<empty>",
  "SearchAlerts_Type_followQuery": "คิวรี",
  "SearchAlerts_Type_followDocument": "รายการ",
  "SearchAlerts_unFollowing": "หยุดการติดตาม",
  "SearchAlerts_follow": "ติดตาม",
  "SearchAlerts_followed": "ติดตามแล้ว",
  "SearchAlerts_followQuery": "ติดตามคิวรี",
  "Subscription_StopFollowingQuery": "หยุดการติดตามคิวรี",
  "SearchAlerts_Frequency": "เวลา",
  "SubscriptionsManageSubscriptions": "จัดการการแจ้งเตือน",
  "SubscriptionsMessageFollowQuery": "คุณจะได้รับการแจ้งเตือนเมื่อคิวรี<b>{0}</b>แสดงรายการใหม่หรือที่อัปเดต",
  "SubscriptionsMessageFollow": "คุณจะได้รับการแจ้งเตือนสำหรับการเปลี่ยนแปลงในรายการ<b>{0}</b>",
  "Expiration": "การหมดอายุ",
  "Monthly": "รายเดือน",
  "Daily": "รายวัน",
  "Monday": "วันจันทร์",
  "Tuesday": "วันอังคาร",
  "Wednesday": "วันพุธ",
  "Thursday": "วันพฤหัสบดี",
  "Friday": "วันศุกร์",
  "Saturday": "วันเสาร์",
  "Sunday": "วันอาทิตย์",
  "NextDay": "ถัดไป {0}",
  "LastDay": "ท้ายสุด {0}",
  "StartTypingCaseForSuggestions": "อธิบายปัญหาของคุณเพื่อหาทางออกที่เป็นไปได้",
  "ExportToExcel": "ส่งออกไปที่ Excel",
  "ExportToExcelDescription": "ส่งออกผลการค้นหาไปที่ Excel",
  "CaseCreationNoResults": "ไม่พบโซลูชันที่แนะนำ",
  "SortBy": "จัดเรียงตาม",
  "BoxCreateArticle": "สร้างบทความ",
  "Facets": "แฟเซ็ท",
  "AdvancedSearch": "การค้นหาขั้นสูง",
  "Keywords": "คำสำคัญ",
  "AllTheseWords": "คำเหล่านี้ทั้งหมด",
  "ExactPhrase": "วลีแบบตรง",
  "AnyOfTheseWords": "คำเหล่านี้คำใดก็ได้",
  "NoneOfTheseWords": "ไม่มีคำเหล่านี้",
  "Anytime": "เวลาใดก็ได้",
  "InTheLast": "ในช่วงสุดท้าย",
  "Days": "วัน",
  "Months": "เดือน",
  "Month": "เดือน",
  "Year": "ปี",
  "Between": "ระหว่าง",
  "Language": "ภาษา",
  "Size": "ขนาด",
  "AtLeast": "อย่างน้อยที่สุด",
  "AtMost": "อย่างมากที่สุด",
  "Contains": "มี",
  "DoesNotContain": "ไม่มี",
  "Matches": "จับคู่",
  "Bytes": "ไบต์",
  "card": "บัตร",
  "table": "ตาราง",
  "ResultLinks": "การเชื่อมโยงผลลัพธ์",
  "EnableQuerySyntax": "เปิดใช้งานซินแท็กซ์คิวรี",
  "On": "เปิด",
  "Off": "ปิด",
  "Automatic": "อัตโนมัติ",
  "ResultsPerPage": "ผลลัพธ์ต่อหน้า",
  "PreviousMonth": "เดือนก่อนหน้า",
  "NextMonth": "เดือนถัดไป",
  "Title": "ชื่อ",
}

  var locales = String["locales"] || (String["locales"] = {});
  locales["th"] = merge(locales["th"], dict);
  String["toLocaleString"].call(this, { "th": dict });
  String["locale"] = "th";
  String["defaultLocale"] = "en";
  Globalize.culture("th")
}